unit Isamtabl;
{$IFDEF VER90}
{$H-}
{$ENDIF}
interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, DsgnIntf,
  UUseIsam, Filer, LowBrows,
  Restruct, ReIndex, ExtCtrls;

type
  TIsamProperty = class(TStringProperty)
  public
    function GetAttributes: TPropertyAttributes; override;
    procedure GetValueList(List: TStrings); virtual; abstract;
    procedure GetValues(Proc: TGetStrProc); override;
  end;

  TIsamBrowserProperty = class(TIsamProperty)
    procedure GetValueList(List: TStrings); override;
  end;

  TIsamHeaderProperty = class(TIsamProperty)
    procedure GetValueList(List: TStrings); override;
  end;

  TIsamTable = class(TComponent)
  private
    FActive      : Boolean;
    FAnsiConvert : Boolean;
    FTableName   : TFileName;
    FIsamKey     : TStringList;
    FRecordName  : String;
    FRecord      : TStringList;
    FIID         : TStringList;
    FNetz        : NetSupportType;
    FSaveModus   : Boolean;
    FSourceCreate: Boolean;
    FBrowserName : String;
    FHeaderName  : String;
    Function Check(Name : String; SS : TStringList) : Boolean;
    procedure CheckInactive;
    function GetActive: Boolean;
    procedure SetActive(Value: Boolean);
    procedure SetTableName(const Value: TFileName);

    procedure SetRecordName(const Value: String);
    Procedure SetHeaderName(const Value: String);
    Procedure SetBrowserName(const Value: String);
    Function  GetFormName(SList: TStringList): String;

  protected
    Procedure SetRecord(Value: TStringList);
    Procedure SetKeyProc(Value: TStringList);
    Procedure SetIIDProc(Value: TStringList);
    Procedure SetNetz(Value: NetSupportType);
    Procedure SetAnsiConvert(Const Value: Boolean);
  public
    IFBPtr    : IsamFileBlockPtr;
    Key_Proc  : KeyProc;
    RecSize   : Longint;
    KeyNo     : Integer;
    Ref       : Longint;
    Key       : IsamKeyStr;
    MaxKeys   : Byte;
    IID       : IsamIndDescr;
    EditFormIdent: String;
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    Procedure Open;
    Procedure Close;
    Procedure ClearFields(var DATA,DUP);
    Procedure Delete(var DATA,DUP);
    Procedure Insert(var DATA,DUP);
    Procedure Append(var DATA,DUP);
    Procedure UpdateRecord(var DATA, DUP);
    Procedure Get(var DATA, DUP);
    Procedure Next(var DATA,DUP);
    Function  FindKey(Var Data,Dup;var Key1 : IsamKeyStr) : Boolean;
    Function  FindNearest(Var Data,Dup; Key1 : IsamKeyStr) : Boolean;
    Procedure Prior(var DATA,DUP);
    Procedure First(var DATA,DUP);
    Procedure Last(var DATA,DUP);
    Procedure CreateTable;
    Function Rebuild: LongInt;
    Function RecordCount: Longint;
  published
    property Active: Boolean read GetActive write SetActive default False;
    Property AnsiConvert: Boolean read FAnsiConvert write SetAnsiConvert default True;
    Property BrowserName: String read FBrowserName write SetBrowserName;
    Property HeaderName: String read FHeaderName write SetHeaderName;
    property TableName: TFileName read FTableName write SetTableName;
    property RecordName: String read FRecordName write SetRecordName;
    property IsamKeyProc: TStringList read FIsamKey write SetKeyProc;
    property IsamRecord: TStringList read FRecord write SetRecord;
    property Netz: NetSupportType read FNetz write SetNetz default NoNet;
    property SaveModus: Boolean read FSaveModus write FSaveModus default False;
    property AnzahlKeys: Byte read MaxKeys write MaxKeys default 1;
    property IIDProc : TStringList read FIID write SetIIDProc;
  end;
           
  var NetType: NetSupportType;

implementation

Uses UToolDll, ExptIntf,
     FvcBrows, IsamBrow, Proxies, Dat;

var FHandle: Longint;
    MyNet  : NetSupportType;

function TIsamProperty.GetAttributes: TPropertyAttributes;
begin
  Result := [paValueList, paSortList, paMultiSelect, paReadOnly];
end;

procedure TIsamProperty.GetValues(Proc: TGetStrProc);
var
  I: Integer;
  Values: TStringList;
begin
  Values := TStringList.Create;
  try
    GetValueList(Values);
    for I := 0 to Values.Count - 1 do Proc(Values[I]);
  finally
    Values.Free;
  end;
end;

procedure TIsamBrowserProperty.GetValueList(List: TStrings);
var I: Integer;
    Component: TComponent;
begin
  i:= 0;
  While I < Designer.Form.ComponentCount do begin
    Component := Designer.Form.Components[I];
    if (Component is TIsamBrowser)
    and (Component.Name <> '') then List.Add(Component.Name);
    Inc(i);
  end;
end;

procedure TIsamHeaderProperty.GetValueList(List: TStrings);
var I: Integer;
    Component: TComponent;
begin
  i:= 0;
  While I < Designer.Form.ComponentCount do begin
    Component := Designer.Form.Components[I];
    if (Component is THeader) and (Component.Name <> '') then List.Add(Component.Name);
    Inc(i);
  end;
end;

constructor TIsamTable.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  FAnsiConvert:= True;
  IFBPTR:= NIL;
  RecSize:= 0;
  KeyNo:= 1;
  Ref:= 0;
  Key_Proc:= NIL;
  FTableName:= '';
  FRecordName:= '';
  MaxKeys := 1;
  FIsamKey:= TStringList.Create;
  FRecord:= Tstringlist.create;
  FIID := TStringList.Create;
  if (csDesigning in ComponentState) then
  if Toolservices <> NIL then
  begin
    FIsamKey.Add('Function '+FRecordName+'KeyProc(Var Daten; KeyNr:Word): IsamKeyStr;');
    FIsamKey.Add('var s : String;');
    FIsamKey.Add('begin');
    FIsamKey.Add('  s:= '+Chr(39)+Chr(39)+';');
    FIsamKey.Add('  with '+FRecordName+'(Daten) do begin');
    FIsamKey.Add('    case KeyNr of');
    FIsamKey.Add('      1 : S:= '+Chr(39)+Chr(39)+';');
    FIsamKey.Add('    End;');
    FIsamkey.Add('  end;');
    FIsamKey.Add('  KeyProc:= s;');
    FIsamkey.Add('end;');
    FIsamkey.Add('');

    FRecord.Add('Type');
    FRecord.Add(FRecordName+' = Record');
    FRecord.add('  Dummy : Longint;');
    FRecord.add('end;');
  end;
  if (csDesigning in ComponentState) then
  if (csdesigning in componentstate) then begin
    GetFHandle(FHandle);
  end;
  EditFormIdent:= '';
end;

destructor TIsamTable.Destroy;
begin
  CheckInactive;
  FIsamKey.Free;
  FRecord.Free;
  FIID.Free;
  inherited Destroy;
end;

Function TIsamTable.GetFormName(SList: TStringList): String;
var S: Integer;
    SStr: String;
    Gefunden: Boolean;
begin
  S:= 0;
  SStr:= '';
  Gefunden:= False;
  While (S < SList.Count) and (Gefunden = False) do begin
    SStr:= UpperCase(SList[S]);
    Strip(SStr);
    if Pos('=CLASS',SStr) > 0 then Gefunden:= True
    else Inc(S);
  end;
  If Gefunden then begin
    SStr:= Copy(SStr,1,Pos('=CLASS',SStr)-1);
  end
  else SStr:= '';
  Result:= SStr;
end;


Function TIsamTable.Check(Name:String; SS:TStringList) : Boolean;
Var
  SStr : String;
  i    : word;
begin
  i := 0;
  Name := UpperCase(Name);
  Strip(Name);
  Check := True;
  if SS.Count > 0 then
  repeat
    SStr:= SS[i];
    SStr:= Uppercase(SStr);
    Strip(SStr);
    if Pos(Name,SStr) > 0 then exit;
    inc(i);
  Until (i >= SS.Count);
  Check := False;
end;


Procedure TIsamTable.SetAnsiConvert(Const Value: Boolean);
begin
  FAnsiConvert:= Value;
end;

Procedure TIsamTable.SetNetz(Value: NetSupportType);
begin
  FNetz:= Value;
end;

Procedure TIsamTable.CheckInactive;
begin
  Active:= False;
end;

function TIsamTable.GetActive: Boolean;
begin
  Result := (FActive = True);
end;


procedure TIsamTable.SetActive(Value: Boolean);
var AllesOk : Boolean;
begin
  AllesOk := True;
  if FActive <> Value then begin
    if Value then begin
      if TableName <> '' then begin
        if BtFileBlockIsOpen(IFBPtr) then begin
          if Sprache = 1 then Errorwindow('Isamtable '+__Laufwerk+TableName,'is already opened')
          else Errorwindow('Die Isamdatei: '+__Laufwerk+TableName,'ist bereits geffnet');
          FActive := True;
          Value := True;
          AllesOk := False;
        end else
        begin
          FActive := False;
          if MyNet <> NoNet then Netz := MYNet;
          InitIsam(Netz);
          if not ExistIsam(IFBPtr,__LAUFWERK+TableName) then
          {New Function in UUSeIsam, will test whether IsamTable exists}
          begin
            if Sprache = 1 then Errorwindow('Isamtable '+__Laufwerk+TableName+' does not exist in the active path','')
            else Errorwindow('Isamtabelle: '+__Laufwerk+TableName+' existiert nicht im angegebenen Directory !','');
            FActive := False;
            Value  := False;
            AllesOk := False;
            exit;
          end;
          if RecSize = 0 then begin
            if Sprache = 1 then Errorwindow('Isamtable will be opened local','')
            else Errorwindow('Die Isamdatei wird lokal','geffnet');
            BTOpenFileBlock(IFBPtr,__Laufwerk+TableName,False,False,SaveModus,False);
            Diee;
            if ISAMOK then FActive:= True else AllesOk := False;
          end
          else begin
            if not(csDesigning in ComponentState) then begin
              GetFHandle(FHandle);
            end;
            DateiOeffnen (IFBPtr,__Laufwerk+TableName,SaveModus,RecSize);
            DIEE;
            if ISAMOK then FActive:= True
            else begin
              AllesOk := False;
              if BtFileBlockIsOpen(IFBPtr) then begin
                DateiSchliessen(IFBPtr);
                DIEE;
              end;
            end;
          end;
        end;
      end
      else begin
        if Sprache = 1 then Errorwindow('no tablename assigned','')
        else Errorwindow('kein Tabellenname angegeben','');
      end;
    end
    else begin
      if BtFileBlockIsOpen(IFBPtr) then begin
        DateiSchliessen(IFBPtr);
        DIEE;
      end;
      FActive:= False;
      ExitIsam;
    end;
  end;
  if not AllesOk then begin
    if Sprache = 1 then Errorwindow('SETACTIVE-Error','Last ISAMERROR: '+DezStr(IsamError))
    else Errorwindow('In SetActive ist ein Fehler aufgetreten',
                      'letzter IsamError: '+DezStr(IsamError));
  end;
end;

procedure TIsamTable.SetTableName(const Value: TFileName);
var S: String;
begin
  CheckInactive;
  S:= Value;
  if Pos('.',S) > 0 then begin
    S:= Copy(S,1,Pos('.',S)-1);
  end;
  While Pos('\',S) > 0 do begin
    S:= Copy(S,Pos('\',S)+1,Length(S));
  end;
  FTableName := S;
end;

procedure TIsamTable.SetRecordName(Const Value: String);
var i: Integer;
    Gefunden: Boolean;
    SStr: String;
begin
  if FRecordName <> Value then begin
    FRecordName := Value;
    if (csdesigning in componentstate) then begin
      {if Owner is TForm then begin
        if TForm(Owner).Designer <> NIL then TForm(Owner).Designer.Modified;
      end;}
      i:= 0;
      Gefunden:= False;
      While (i < FIsamKey.Count) and (Gefunden = False) do begin
        SStr:= UpperCase(FIsamKey[i]);
        Strip(SStr);
        if (Pos('(DATEN)',SStr) > 0) then Gefunden:= True
        else Inc(i);
      end;
      if Gefunden then begin
        FIsamKey[i]:= '  with '+FRecordName+'(Daten) do begin';
      end;
      i:= 0;
      Gefunden:= False;
      While (i < FRecord.Count) and (Gefunden = False) do begin
        SStr:= UpperCase(FRecord[i]);
        Strip(SStr);
        if (Pos('=RECORD',SStr) > 0) then Gefunden:= True
        else Inc(i);
      end;
      if Gefunden then begin
        FRecord[i]:= FRecordName+' = Record';
      end;
    end;
  end;
end;


Procedure TIsamTable.SetRecord(Value: TStringList);
begin
  FRecord.Assign(Value);
end;


Procedure TIsamTable.SetBrowserName(Const Value: String);
begin
  if FBrowserName <> Value then
  begin
    FBrowserName:= Value;
  end;
end;


Procedure TIsamTable.SetHeaderName(Const Value: String);
begin
  if FHeaderName <> Value then
  begin
    FHeaderName := Value;
  end;
end;

Procedure TIsamTable.SetKeyProc(Value: TStringList);
begin
  FIsamKey.Assign(Value);
end;

Procedure TIsamTable.SetIIDProc(Value: TStringList);
begin
  FIID.Assign(Value);
end;


Procedure TIsamTable.Open;
begin
  Active:= True;
end;

Procedure TIsamTable.Close;
begin
  CheckInactive;
end;

{
  FindFirst  = 0;
  FindLast   = 1;
  FindNext   = 2;
  FindPrev   = 3;
  FindALL    = 4;
}

Procedure TIsamTable.First(var DATA, DUP);
begin
  if Active then begin
    Nachbarkey(IFBPtr,KeyNo,Ref,Key,0);
    DIEE;
    if ISAMOK then begin
      SatzLesen (IFBPtr,Ref,Data,Dup);
      DIEE;
    end;
  end;
end;

Procedure TIsamTable.CreateTable;
Var Act : Boolean;
    Txt1,Txt2: String;
    SuchFBptr: IsamFileBlockPtr;
begin
  Act := Active;
  if Active then Close;
  if Sprache = 1 then begin
    Txt1:= 'Table '+__Laufwerk+TableName+' already exists.';
    Txt2:= 'overwrite ?';
  end
  else begin
    Txt1:= 'IsamTabelle '+__Laufwerk+TableName+' existiert schon.';
    Txt2:= 'berschreiben ?';
  end;
  New(SuchFbPtr);
  if existIsam(SuchFbPtr,__Laufwerk+TableName+'.Dat') then if not Janein(Txt1,Txt2) then
  begin
    if Act then Open;
    exit;
  end;
  Dispose(SuchFbPtr);
  if MyNet <> NoNet then Netz := MYNet;
  InitIsam(Netz);
  if RecSize = 0 then begin
    if Sprache = 1 then Errorwindow('No recordsize assigned','')
    else Errorwindow('Recordgre ist nicht angegeben','');
  end
  else begin
    BTCREATEFileBlock(__Laufwerk+TableName,RecSize, MaxKeys, IID);
    DIEE;
  end;
  ExitIsam;
  if Act then Open;
end;

{$F+}
Procedure DisplayRebuildInfo (     KeyNr   : Integer;
                                   NrRead,
                                   NrWrite : LongInt;
                               Var DatS;
                                   Len     : Word );

Begin
  Waitwindow('KeyNr.: '+DezStr(KeyNr),
             'NrRead: '+DezStr(NrRead)+' NrWrite: '+DezStr(NrWrite));
End;
{$F-}

Function TIsamTable.Rebuild: LongInt;
Const
  MsgFileCreated : Boolean = True;
Var Act: Boolean;
    Komplett : Boolean;
begin
  Komplett := True;

  {
    Bitte hierhin noch eine Abfrage:
    () Index reorganisieren
    () Index und Datenstze reorganisieren

    ok           Abbruch
  }

  if TableName = '' then begin
    if Sprache = 1 then Errorwindow('No tablename assigned','')
    else Errorwindow('Tabellenname wurde nicht angegeben','')
  end
  else begin

    Act:= Active;
    if Active then Close;
    if Sprache = 1 then WaitWindow('Reorg starts','')
    else WaitWindow('Reorg beginnt','');
    if MyNet <> NoNet then Netz := MYNet;
    InitIsam(Netz);
    IsamReXUserProcPtr := {@}DisplayRebuildInfo;


    if komplett then
    RestructFileBlock ( __Laufwerk+TableName,
                        RecSize,
                        RecSize,
                        False,
                        -1,
                        ChangeDatSNoChange,
                        BTNoCharConvert,
                        Nil);

    ReIndexFileBlock (__Laufwerk+TableName,
                      MaxKeys,
                      IID ,
                      False,
                      Key_Proc,
                      False,
                      MsgFileCreated,
                      BTNoCharConvert,
                      Nil);



    ExitIsam;
    CloseWait;
    if Act then Open;
  end;
  Rebuild := IsamError;
end;

Procedure TIsamTable.Insert(var DATA, DUP);
begin
  if Active then begin
    SatzAnlegen (IFBPtr,Data,Key_Proc);
    DIEE;
    Get(DATA,DUP);
  end;
end;

Procedure TIsamTable.Append(var DATA, DUP);
begin
  if Active then begin
    SatzAnlegen (IFBPtr,Data,Key_Proc);
    DIEE;
    Get(DATA,DUP);
  end;
end;

Procedure TIsamTable.UpdateRecord(var DATA, DUP);
var Ok: Boolean;
begin
  if Active then begin
    SatzAendern(IFBPtr,Ref,DATA,DUP,Key_Proc,Ok);
    DIEE;
    Get(DATA,DUP);
  end;
end;

Procedure TIsamTable.Get(var DATA, DUP);
begin
  if Active then begin
    SatzLesen (IFBPtr,Ref,Data,Dup);
    DIEE;
    Key:= Key_Proc(DATA,KeyNo);
  end;
end;

Procedure TIsamTable.Last(var DATA, DUP);
begin
  if Active then begin
    Nachbarkey(IFBPtr,KeyNo,Ref,Key,1);
    DIEE;
    if ISAMOK then begin
      SatzLesen (IFBPtr,Ref,Data,Dup);
      DIEE;
    end;
  end;
end;

Procedure TIsamTable.ClearFields(var DATA, DUP);
begin
  if Active then begin
    Fillchar(Data,Sizeof(Data),0);
    Fillchar(Dup,Sizeof(Dup),0);
  end;
end;

Procedure TIsamTable.Delete(var DATA, DUP);
var Ok: Boolean;
begin
  if Active then
  begin
     Satzloeschen(IFBPtr,Ref,Dup,Key_Proc,OK);
     Diee;
  end
  else begin
    if Sprache = 1 then Errorwindow('Table is not opened','')
    else Errorwindow('Tabelle ist nicht aktiv','');
  end;
end;

Procedure TIsamTable.Next(var DATA, DUP);
begin
  if Active then begin
    Nachbarkey(IFBPtr,KeyNo,Ref,Key,2);
    DIEE;
    if ISAMOK then begin
      SatzLesen (IFBPtr,Ref,Data,Dup);
      DIEE;
    end;
  end;
end;

Function TIsamTable.FindKey(Var Data,Dup;var Key1 : IsamKeyStr) : Boolean;
Var Found : Boolean;
begin
  Found := False;
  if Active then begin
    KeySuchen (IFBPtr,KeyNo,Ref,Key1,Found);
    Diee;
    if Found then
    begin
      SatzLesen (IFBPtr,Ref,Data,Dup);
      DIEE;
      Key1:= Key_Proc(Data,KeyNo);
      Key:= Key1;
    end;
  end;
  FindKey := Found;
end;

Function TIsamTable.FindNearest(Var Data,Dup; Key1 : IsamKeyStr) : Boolean;
Var Found : Boolean;
begin
  Found := False;
  if Active then begin
    KeySuchen (IFBPtr,KeyNo,Ref,Key1,Found);
    Diee;
    SatzLesen (IFBPtr,Ref,Data,Dup);
    DIEE;
    Found := True;
  end;
  FindNearest := Found;
end;

Procedure TIsamTable.Prior(var Data,Dup);
begin
  if Active then begin
    Nachbarkey(IFBPtr,KeyNo,Ref,Key,3);
    DIEE;
    if ISAMOK then begin
      SatzLesen (IFBPtr,Ref,Data,Dup);
      DIEE;
    end;
  end;
end;

Function TIsamTable.RecordCount: Longint;
begin
  if IFBPTR <> NIL then Result:= BtUsedRecs(IFBPtr)
  else Result:= 0;
end;


begin
  FHandle:= InitToolDll;
  NetType := NoNet;
  if __Netz = 'NONET' then NetType := NoNet;
  if __Netz = 'MSNET' then NetType := MsNet;
  if __Netz = 'NOVELLNET' then NetType := Novell;
  MyNet := NetType;
end.


